
***************************************************************************************************************
***     ANALYSIS:  Capturing Multiple Perspectives in a Multi-actor Survey: 								***
***				   The Impact of Parental Presence in Child Interviews on Reporting Discrepancies 			***	
***		DATA:      Pairfam waves 1 to 9, Release 9.1 						  			  					***
***																											***
*** 	CONTENT:   - Data preparation: Restricted sample (Section 3.2)					  					***	
***				   - Differences by parental presence, restricted Sample (Appendix Table A2)	  			***	
***				   - Descriptive statistics, restricted Sample (Table 3, Section 4.1)	  					***	
***				   - Linear fixed-effects regression models (Section 4.2 and Tables 4 and 5, Section 4.2) 	***
***************************************************************************************************************

clear all
set maxvar 15000
set more off
set varabbrev off

global path1 `""datapath""'  
global path2 `""outputpath""'  
global path3 `""syntaxpath""'  


****************************
***  Restricted Sample   ***
****************************

** Parent-child dyads with at least two observations in waves 6 to 9 and without missing values in outcome measures and independent variables

cd $path1	
use parentpres.dta, clear

gen help=0
replace help=1 if missing(diffext, diffint, diffnegcomm, diffconflict, pres, kagen, firstpart, intim, monitor, assertive)
keep if help==0
drop help
	
cap drop pycount
bysort cid: gen pycount = _N   					// # of observations (within child-parent dyad)
keep if pycount>1

cap drop py*
bysort cid (wave): gen pynrc = _n           	// observation ID (within child-parent dyad)
count											// N=3,183 observations
tab pynrc if pynrc==1, m						// N=1,132 child-parent dyads

save sample_res_temp.dta, replace				// Sample used for descriptive statistics displayed in Appendix Table A2

* Test for significant differences in outcome variables
foreach var of varlist diffext diffint diffnegcomm diffconflict{
	ttest `var', by(pres)		// Significant differences in diff. scores regarding negative communication and conflict
}



** Parent-child dyads with at least two observations and without missing values in variables used in fixed-effects analyses 
* (dependent variables: reporting discrepancies regarding negative communication and conflicts)

cd $path1	
use parentpres.dta, clear

gen help=0
replace help=1 if missing(diffnegcomm, diffconflict, pres, kagen, firstpart, intim, monitor, assertive)
keep if help==0
drop help

cap drop pycount
bysort cid: gen pycount = _N   					// # of observations (within child-parent dyad)
keep if pycount>1
	
keep id cid wave pres *diff* *age* nbpart firstpart monitor *intim* auton assertive pcr3i1 pcr3i8
sort id wave

save sample_res.dta, replace					// Restricted sample for analyses of reporting diff. in negative communication and conflicts


** Number of dyads and observations
cap drop py*
bysort cid (wave): gen pynrc = _n           	// observation ID (within child-parent dyad)
bysort id  (wave): gen pynr  = _n           	// observation ID (within child-parent dyad)
bysort cid: gen pycount = _N   					// # of observations (within child-parent dyad)

count											// N=3,191 observations
tab pynrc if pynrc==1, m						// N=1,134 child-parent dyads
tab pynr if pynr==1								// N=842 anchor households

gen help=0
bysort cid (wave): replace help=1 if (pres==1 & pres[_n-1]==0) |  (pres==0 & pres[_n-1]==1)
bysort cid (wave): egen help2= max(help)

tab help2 if pynrc==1							// Change in parental presence at least once within observation period for 372 children (32.8%) 
drop help*


***********************************************************
*** 	Restricted sample for hyperactivity analyses    ***
***********************************************************

** Parent-child dyads with observations in waves 7 and 9 and without missing values on hyperactivity discrepancies and independent variables 

use parentpres.dta, replace 
gen help=0
replace help=1 if missing(diffhyper, pres, kagen, firstpart, intim, monitor, assertive)
keep if help==0
drop help
	
cap drop pycount
bysort cid: gen pycount = _N   					// # of observations (within child-parent dyad)
keep if pycount>1

keep  id cid wave pres *diff* *age* nbpart firstpart monitor *intim* auton assertive 
sort id wave

save sample_res2.dta, replace					// Restricted sample for hyperactivity analyses

** Number of parent-child dyads and observations 
cap drop py*
bysort cid (wave): gen pynrc = _n           	// observation ID (within child-parent dyad)
bysort id (wave): gen pynr = _n           		// observation ID (within child-parent dyad)
bysort cid: gen pycount = _N   					// # of observations (within child-parent dyad)

count											// N=1,000 observations
tab pynrc if pynrc==1							// N=500 child-parent dyads
tab pynr if pynr==1								// N=402 anchor households

gen help=0
bysort cid (wave): replace help=1 if (pres==1 & pres[_n-1]==0) | (pres==0 & pres[_n-1]==1)
bysort cid (wave): egen help2= max(help)

tab help2 if pynrc==1							// Change in parental presence at least once within observation period for 111 children (22.2%) 
drop help* 
	
	
**************************************************************************************************************
***  Appendix Table A2: Differences by parental presence, sample with at least two observations per dyad   ***
**************************************************************************************************************

cd $path1
use sample_res_temp.dta, clear	

ttest kagen, by(pres)		// Age
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest kagen, by(pres)

ttest nbpart, by(pres) 		// Number of interviews
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest nbpart, by(pres)

ttest assertive, by(pres) 	// Assertiveness 
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest assertive, by(pres)

ttest monitor, by(pres)		// Monitoring 
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest monitor, by(pres)

ttest intim, by(pres)		// Intimacy 
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest intim, by(pres)

ttest auton, by(pres)		// Autonomy 
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest auton, by(pres)

** Child-parent difference scores
foreach var of varlist diffext diffint diffnegcomm diffconflict{
	ttest `var', by(pres)
	makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest `var', by(pres)
}

cap drop py*
bysort cid (wave): gen pynrc = _n           	
tab pynrc if pynrc==1, m				// N (dyads) = 1,132

erase sample_res_temp.dta


** Child-parent diff. scores: Hyperactivity
cd $path1
use sample_res2.dta, clear

ttest diffhyper, by(pres)
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest diffhyper, by(pres)



**************************************************************************************************************
***	  Table 3, Section 4.1: Descriptive statistics of sample characteristics for fixed-effects analyses    ***
**************************************************************************************************************

cd $path1
use sample_res.dta, clear			

** Percent/Mean (SD) of observations
tab pres
sum kagen
tab firstpart, m
sum assertive monitor intim 

foreach var of varlist diffnegcomm diffconflict{
	sum a`var'
}

** Percent changes between waves (dyads)
foreach var of varlist pres kagen firstpart assertive monitor intim {
	cap drop py*
	bysort cid (wave): gen pynrc = _n           	// observation ID (within parent-child dyad)
	cap drop help
	gen help`var'=.
	bysort cid (wave): replace help`var'=0 if `var'!=.
	bysort cid (wave): replace help`var'=1 if `var'!=`var'[_n-1] & pynrc!=1
	bysort cid (wave): egen help2`var'=max(help`var') if help`var'!=.
	
	tab help2`var' if pynrc==1	
	drop help*
}

foreach var of varlist diffnegcomm diffconflict {
	cap drop py*
	bysort cid (wave): gen pynrc = _n           	// observation ID (within parent-child dyad)
	cap drop help
	gen help`var'=.
	bysort cid (wave): replace help`var'=0 if a`var'!=.
	bysort cid (wave): replace help`var'=1 if a`var'!=a`var'[_n-1] & pynrc!=1
	bysort cid (wave): egen help2`var'=max(help`var') if help`var'!=.
	
	tab help2`var' if pynrc==1					// note that age does not change for all respondents, as for those with only two observations 
												// the interview date of the second of these observations may lie before the birthday of the child
												// (field period october-february)
	drop help*
}

** Within-dyad difference of values observed in the last and the first person-year 
cap drop py*
bysort cid (wave): gen pynrc = _n           	// observation ID (within parent-child dyad)
bysort cid (wave): egen max=max(pynrc)
bysort cid (wave): egen min=min(pynrc)

foreach var of varlist assertive monitor intim {
	gen helpmax`var'=`var' if pynrc==max
	bysort cid (wave): egen summax`var'=sum(helpmax`var') 
	gen helpmin`var'=`var' if pynrc==min
	bysort cid (wave): egen summin`var'=sum(helpmin`var') 
}
 
*br cid wave pynrc max min intim helpmaxintim helpminintim summaxintim summinintim

foreach var of varlist assertive monitor intim {
	gen diffobs`var'=summax`var'-summin`var'
	sum diffobs`var' if inlist(pynrc,1,2)
}

drop py* sum* *max* *min* diffobs*

foreach var of varlist diffnegcomm diffconflict {
	cap drop py*
	bysort cid (wave): gen pynrc = _n           	// observation ID (within parent-child dyad)
	bysort cid (wave): egen max=max(pynrc)
	bysort cid (wave): egen min=min(pynrc)

	gen helpmax`var'=a`var' if pynrc==max
	bysort cid (wave): egen summax`var'=sum(helpmax`var') 
	gen helpmin`var'=a`var' if pynrc==min
	bysort cid (wave): egen summin`var'=sum(helpmin`var') 
	 
	gen diffobs`var'=summax`var'-summin`var'
	sum diffobs`var' if inlist(pynrc,1,2)

	drop py* sum* *max* *min* diffobs*
}


*** Sample characteristics hyperactivity reports (waves 7 & 9) 
cd $path1
use sample_res2.dta, clear	

** Percent/Mean (SD) of observations
sum adiffhyper

** Percent changes between waves (dyads)
cap drop py*
bysort cid (wave): gen pynrc = _n           	// observation ID (within parent-child dyad)
cap drop help
gen helpdiffhyper=.
bysort cid (wave): replace helpdiffhyper=0 if adiffhyper!=.
bysort cid (wave): replace helpdiffhyper=1 if adiffhyper!=adiffhyper[_n-1] & pynrc!=1
bysort cid (wave): egen help2diffhyper=max(helpdiffhyper) if helpdiffhyper!=.
	
tab help2diffhyper if pynrc==1
drop help*

** Within-dyad difference of values observed in the last and the first person-year 
cap drop py*
bysort cid (wave): gen pynrc = _n           	// observation ID (within parent-child dyad)
bysort cid (wave): egen max=max(pynrc)
bysort cid (wave): egen min=min(pynrc)

gen helpmaxdiffhyper=adiffhyper if pynrc==max
bysort cid (wave): egen summaxdiffhyper=sum(helpmaxdiffhyper) 
gen helpmindiffhyper=adiffhyper if pynrc==min
bysort cid (wave): egen summindiffhyper=sum(helpmindiffhyper) 
	 
gen diffobsdiffhyper=summaxdiffhyper-summindiffhyper
sum diffobsdiffhyper if inlist(pynrc,1,2)

drop py* sum* *max* *min* diffobs*



****************************************************************
***    Section 4.2:  Fixed effects regression models		 ***
****************************************************************

*** Dependent Variable: Discrepancies in Reports of Hyperactivity

cd $path1
use sample_res2.dta, clear
xtset cid wave

** Baseline models, including age and first interview
xtreg adiffhyper pres c.kagen i.firstpart, fe  vce(cluster id)
*xtreg adiffhyper pres c.kagen##c.kagen i.firstpart, fe  vce(cluster id)					// including age-squared to account for non-linearity

** Models including intimacy of communication						
xtreg adiffhyper pres c.kagen i.firstpart c.intim, fe  vce(cluster id)

** Models including intimacy of communication,  monitoring
xtreg adiffhyper pres c.kagen i.firstpart c.intim c.monitor, fe  vce(cluster id)
	
** Models including intimacy of communication, monitoring, and assertiveness
xtreg adiffhyper pres c.kagen i.firstpart c.intim c.monitor c.assertive, fe  vce(cluster id)
est store adiffhyper


*** TABLE 4, Section 4.2: Estimation results 
estimates table adiffhyper, b(%7.3f) star stfmt(%6.0f) stats(N N_clust) 
estimates table adiffhyper, b(%7.3f) se(%7.3f) stfmt(%6.0f) stats(N N_clust) 

cd $path2
esttab 	adiffhyper using Table4a.rtf, ///
		r2(4) b(3) se(3) noconstant nobaselevels ///
		label title("Fixed-effects regression analyses of parental presence effects") ///
		addnote("Unstandardized B coefficients, cluster robust standard errors in parentheses.") star(* 0.05 ** 0.01 *** 0.001) ///
		stats(N N_g r2, fmt(%9.0g %9.0g %9.3f ) labels("N (observations)" "N (dyads)" "Within")) ///
		modelwidth(7) replace
		

*** Directionally-sensitve outcome measures (Section 4.2)
xtreg  diffhyper pres c.kagen i.firstpart, fe  vce(cluster id)										// Baseline models
xtreg  diffhyper pres c.kagen i.firstpart c.intim c.monitor c.assertive, fe  vce(cluster id) 		// Fully specified models


*** Dependent Variables: Discrepancies in Reports of Negative communication and Conflicts

cd $path1
use sample_res.dta, clear

xtset cid wave
xtdes, pattern(30)                 				

pwcorr kagen nbpart, sig		// correlation between age and number of interviews r=0.84 (Section 3.4)
*graph matrix kagen nbpart
pwcorr kagen assertive
pwcorr kagen monitor
pwcorr kagen intim

tab kagen pres, m
bysort agekat2: tab nbpart, m

** Baseline models, including age and first interview
foreach var of varlist diffnegcomm diffconflict{	
	xtreg a`var' pres c.kagen i.firstpart, fe  vce(cluster id)
	*xtreg a`var' pres c.kagen##c.kagen i.firstpart, fe  vce(cluster id)			// including age-squared to account for non-linearity		
}

** Models including intimacy of communication
foreach var of varlist diffnegcomm diffconflict{							
	xtreg a`var' pres c.kagen i.firstpart c.intim, fe  vce(cluster id)
}

** Models including intimacy of communication,  monitoring
foreach var of varlist diffnegcomm diffconflict{							
	xtreg a`var' pres c.kagen i.firstpart c.intim c.monitor, fe  vce(cluster id)
}
	
** Models including intimacy of communication, monitoring, and assertiveness
foreach var of varlist diffnegcomm diffconflict{	
	xtreg a`var' pres c.kagen i.firstpart c.intim c.monitor c.assertive, fe  vce(cluster id)
	est store a`var'
}

*** TABLE 4: Estimation results 
estimates table adiffnegcomm adiffconflict, b(%7.3f) star stfmt(%6.0f) stats(N N_clust) 
estimates table adiffnegcomm adiffconflict, b(%7.3f) se(%7.3f) stfmt(%6.0f) stats(N N_clust) 


cd $path2
esttab 	adiffnegcomm adiffconflict using Table4b.rtf, ///
		r2(4) b(3) se(3) noconstant nobaselevels ///
		label title("Fixed-effects regression analyses of parental presence effects") ///
		addnote("Unstandardized B coefficients, cluster robust standard errors in parentheses.") star(* 0.05 ** 0.01 *** 0.001) ///
		stats(N N_g r2, fmt(%9.0g %9.0g %9.3f ) labels("N (observations)" "N (dyads)" "Within")) ///
		modelwidth(7) replace
		

*** Applying regression models to directionally-sensitve outcome measures (Section 4.2)

** Baseline models, including age and first interview
foreach var of varlist diffnegcomm diffconflict{	
	xtreg `var' pres c.kagen i.firstpart, fe  vce(cluster id)		
}
** Models including intimacy of communication, monitoring, and assertiveness
foreach var of varlist diffnegcomm diffconflict{	
	xtreg `var' pres c.kagen i.firstpart c.intim c.monitor c.assertive, fe  vce(cluster id)	
}

   
   
************************************************************************************************
***   Section 4.2:  Fixed effects regression models, including interaction terms with age	 ***
************************************************************************************************

*** Dependent Variables: Discrepancies in Reports of Hyperactivity

cd $path1
use sample_res2.dta, clear
tab kagen pres 
xtset cid wave

** Baseline model with interaction between parental presence and middle childhood (age 8-11)
xtreg adiffhyper i.pres##i.agekat2 c.kagen i.firstpart, fe vce(cluster id)

** Fully specified model with interaction between parental presence and middle childhood (8-11)
xtreg adiffhyper i.pres##i.agekat2 c.kagen i.firstpart c.intim c.monitor c.assertive, fe vce(cluster id)		
est store adiffhyper_ageint


*** TABLE 5: Estimation results 
estimates table adiffhyper_ageint, b(%7.3f) star stfmt(%6.0f) stats(N N_clust) 
estimates table adiffhyper_ageint, b(%7.3f) se(%7.3f) stfmt(%6.0f) stats(N N_clust) 	


cd $path2
esttab 	adiffhyper_ageint using Table5a.rtf, ///
		r2(4) b(3) se(3) noconstant nobaselevels ///
		label title("Fixed-effects regression analyses of parental presence effects") ///
		addnote("Unstandardized B coefficients, cluster robust standard errors in parentheses.") star(* 0.05 ** 0.01 *** 0.001) ///
		stats(N N_g r2, fmt(%9.0g %9.0g %9.3f ) labels("N (observations)" "N (dyads)" "Within")) ///
		modelwidth(7) replace
		

*** Auxiliary analyses (results not shown): Varying age delineations for middle childhood and interactions wit age dummies

xtreg adiffhyper i.pres##i.agekat2a c.kagen i.firstpart c.intim c.monitor c.assertive, fe vce(cluster id)		// 8-10
xtreg adiffhyper i.pres##i.agekat2b c.kagen i.firstpart c.intim c.monitor c.assertive, fe vce(cluster id)		// 8-12		
xtreg adiffhyper i.pres##i.agekat2c c.kagen i.firstpart c.intim c.monitor c.assertive, fe vce(cluster id)		// 8-13	

** Interactions of parental presence with age dummies
xtreg adiffhyper i.pres##i.kagen i.firstpart c.intim c.monitor c.assertive, fe vce(cluster id)


*** Dependent Variables: Discrepancies in Reports of Negative communication / Conflicts

cd $path1
use sample_res.dta, clear
xtset cid wave

** Baseline model with interaction parental presence & middle childhood (8-11)
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.agekat2 c.kagen i.firstpart, fe vce(cluster id)
}

** Fully specified model with interaction parental presence & middle childhood (8-11)
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.agekat2 c.kagen i.firstpart c.intim c.monitor c.assertive, fe vce(cluster id)	
	est store a`var'_ageint
}


*** TABLE 5: Estimation results 
estimates table adiffnegcomm_ageint adiffconflict_ageint, b(%7.3f) star stfmt(%6.0f) stats(N N_clust) 
estimates table adiffnegcomm_ageint adiffconflict_ageint, b(%7.3f) se(%7.3f) stfmt(%6.0f) stats(N N_clust) 

cd $path2
esttab 	adiffnegcomm_ageint adiffconflict_ageint using Table5b.rtf, ///
		r2(4) b(3) se(3) noconstant nobaselevels ///
		label title("Fixed-effects regression analyses of parental presence effects, including interactions with middle childhood") ///
		addnote("Unstandardized B coefficients, cluster robust standard errors in parentheses.") star(* 0.05 ** 0.01 *** 0.001) ///
		stats(N N_g r2, fmt(%9.0g %9.0g %9.3f ) labels("N (observations)" "N (dyads)" "Within")) ///
		modelwidth(7) replace

		

*******************************************************
*** 	Auxiliary analyses (results not shown)  	***
*******************************************************


*** Varying age delineations for middle childhood and interactions wit age dummies

foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.agekat2a c.kagen i.firstpart c.intim c.monitor c.assertive, fe vce(cluster id)		// 8-10
}	
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.agekat2b c.kagen i.firstpart c.intim c.monitor c.assertive, fe vce(cluster id)		// 8-12	
}
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.agekat2c c.kagen i.firstpart c.intim c.monitor c.assertive, fe vce(cluster id)		// 8-13	
}
* Interactions with age dummies
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.kagen i.firstpart c.intim c.monitor c.assertive, fe vce(cluster id)
}


***  Multiplicative interaction terms with lack of intimacy (results not shown) 
	
** Dependent Variable: Discrepancies in Reports of Negative communication
cd $path1
use sample_res.dta, clear
xtset cid wave

tab pres lintim, m
tab pres lintim2, m
tab1 pcr3i1 pcr3i8, m

** Baseline models, interactions with lack of intimacy
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart, fe vce(cluster id)  
}
	
** Full models, interactions with lack of intimacy 
foreach var of varlist diffnegcomm diffconflict{  
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart c.monitor c.assertive, fe vce(cluster id)  
}

** Baseline models by middle childhood and adolescence
bysort agekat2: tab pres lintim		// "Never"/ "Seldom"				coded as 1
bysort agekat2: tab pres lintim2 	// "Never"/ "Seldom"/ "Sometimes" 	coded as 1

foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart if agekat2==0, fe vce(cluster id) 							// Adolescence
}
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart if agekat2==1, fe vce(cluster id)   							// Middle childhood
}

** Full models by middle childhood and adolescence
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart c.monitor c.assertive if agekat2==0, fe vce(cluster id)  	// Adolescence
}
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart c.monitor c.assertive if agekat2==1, fe vce(cluster id)  	// Middle childhood
}

   
** Varying age delineations 

* 8-10 &  11-15
bysort agekat2a: tab pres lintim2, m				
	
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart c.monitor c.assertive if agekat2a==0, fe vce(cluster id) 
}
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart c.monitor c.assertive if agekat2a==1, fe vce(cluster id)   
}

* 8-12 & 13-15
bysort agekat2b: tab pres lintim2, m

foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart c.monitor c.assertive if agekat2b==0, fe vce(cluster id) 
}
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart c.monitor c.assertive if agekat2b==1, fe vce(cluster id)   
}

* 8-13 & 14-15
bysort agekat2c: tab pres lintim2, m

foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart c.monitor c.assertive if agekat2c==0, fe vce(cluster id) 
}
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.lintim2 c.kagen i.firstpart c.monitor c.assertive if agekat2c==1, fe vce(cluster id)   		
}	
	




*** Multiplicative interaction terms with number of interviews (results not shown)   

** Dependent Variable: Discrepancies in Reports of Hyperactivity

cd $path1
use sample_res2.dta, clear

xtset cid wave

tab nbpart, m
gen nbpart1=nbpart
recode nbpart1 (7/max=7)
tab nbpart1 pres
tab nbpart pres
 
** Baseline model
xtreg adiffhyper i.pres##i.nbpart1 i.agekat2,  fe vce(cluster id)			

** Fully specified model
xtreg adiffhyper i.pres##i.nbpart1 i.agekat2 c.intim c.monitor c.assertive, fe vce(cluster id)

xtreg adiffhyper i.pres##i.firstpart i.agekat2,  fe vce(cluster id)
xtreg adiffhyper i.pres##i.firstpart i.agekat2 c.intim c.monitor c.assertive, fe vce(cluster id)


** Dependent Variables: Discrepancies in Reports of Negative Communication
cd $path1
use sample_res.dta, clear

xtset cid wave

tab nbpart, m
gen nbpart1=nbpart
recode nbpart1 (7/max=7)
tab nbpart1 pres
tab nbpart pres

** Baseline model
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.nbpart1 i.agekat2, fe vce(cluster id)     
}

** Fully specified model     
foreach var of varlist diffnegcomm diffconflict{
	xtreg a`var' i.pres##i.nbpart1 i.agekat2 c.intim c.monitor c.assertive, fe vce(cluster id)         
}   


foreach var of varlist diffnegcomm diffconflict{	
	xtreg a`var' i.pres##i.firstpart i.agekat2, fe vce(cluster id)	
	xtreg a`var' i.pres##i.firstpart i.agekat2 c.intim c.monitor c.assertive, fe vce(cluster id)   	
}	
	
	